<?php
/**
 * baserCMS :  Based Website Development Project <https://basercms.net>
 * Copyright (c) baserCMS Users Community <https://basercms.net/community/>
 *
 * @copyright		Copyright (c) baserCMS Users Community
 * @link			https://basercms.net baserCMS Project
 * @package			Baser.View
 * @since			baserCMS v 4.0.0
 * @license			https://basercms.net/license/index.html
 */

/**
 * [ADMIN] ウィジェットエリア一覧 テーブル
 */
$this->BcListTable->setColumnNumber(6);
?>


<div class="bca-data-list__top">
	<!-- 一括処理 -->
	<?php if ($this->BcBaser->isAdminUser()): ?>
		<div class="bca-action-table-listup">
			<?php echo $this->BcForm->input('ListTool.batch', ['type' => 'select', 'options' => ['del' => __d('baser', '削除')], 'empty' => __d('baser', '一括処理'), 'data-bca-select-size' => 'lg']) ?>
			<?php echo $this->BcForm->button(__d('baser', '適用'), ['id' => 'BtnApplyBatch', 'disabled' => 'disabled', 'class' => 'bca-btn', 'data-bca-btn-size' => 'lg']) ?>
		</div>
	<?php endif ?>
	<div class="bca-data-list__sub">
		<!-- list-num -->
		<?php $this->BcBaser->element('list_num') ?>
		<!-- pagination -->
		<?php $this->BcBaser->element('pagination') ?>
	</div>
</div>


<table cellpadding="0" cellspacing="0" class="list-table bca-table-listup" id="ListTable">
	<thead class="bca-table-listup__thead">
	<tr class="">
		<th class="list-tool bca-table-listup__thead-th  bca-table-listup__thead-th--select">
			<?php echo $this->BcForm->input('ListTool.checkall', ['type' => 'checkbox', 'label' => __d('baser', '一括選択')]) ?>
		</th>
		<th class="bca-table-listup__thead-th">No</th>
		<th class="bca-table-listup__thead-th"><?php echo __d('baser', 'ウィジェットエリア名') ?></th>
		<th class="bca-table-listup__thead-th"><?php echo __d('baser', '登録ウィジェット数') ?></th>
		<?php echo $this->BcListTable->dispatchShowHead() ?>
		<th class="bca-table-listup__thead-th"><?php echo __d('baser', '登録日') ?><br><?php echo __d('baser', '更新日') ?>
		</th>
		<th class="bca-table-listup__thead-th">
			<?php echo __d('baser', 'アクション') ?>
		</th>

	</tr>
	</thead>
	<tbody class="bca-table-listup__tbody">
	<?php if (!empty($widgetAreas)): ?>
		<?php foreach($widgetAreas as $data): ?>
			<?php $this->BcBaser->element('widget_areas/index_row', ['data' => $data]) ?>
		<?php endforeach; ?>
	<?php else: ?>
		<tr>
			<td colspan="<?php echo $this->BcListTable->getColumnNumber() ?>">
				<p class="no-data"><?php echo __d('baser', 'データが見つかりませんでした。') ?></p></td>
		</tr>
	<?php endif; ?>
	</tbody>
</table>
